!### makefile for Xaw3D shared library

TARGET = XAW3DLIBSHR
TARGET1 = XAW3D_CLIENT

TARGET_TYPE = shared library

CC_DEFINES = /DEF=(VMS,ARROW_SCROLLBAR)

.ifdef __DECC__
CC_QUALIFIER = /NODEB/NOSHARE/EXT=STRICT/PREF=ALL
.endif

.ifdef __VAXC__
CC_QUALIFIER = /NODEB/OPT=(D,I)
.endif

.include X11_ROOT:[COMMAND]X11_RULES.MMS

!### Objects ###################################################################

OBJS1 =\
ALLWIDGETS.$(OBJ_EXT),\
ASCIISINK.$(OBJ_EXT),\
ASCIISRC.$(OBJ_EXT),\
ASCIITEXT.$(OBJ_EXT),\
BOX.$(OBJ_EXT)

OBJS2 =\
COMMAND.$(OBJ_EXT),\
DIALOG.$(OBJ_EXT),\
FORM.$(OBJ_EXT),\
GRIP.$(OBJ_EXT),\
LABEL.$(OBJ_EXT)

OBJS3 =\
LIST.$(OBJ_EXT),\
MENUBUTTON.$(OBJ_EXT),\
PANED.$(OBJ_EXT),\
PANNER.$(OBJ_EXT),\
PORTHOLE.$(OBJ_EXT)

OBJS4 =\
REPEATER.$(OBJ_EXT),\
SCROLLBAR.$(OBJ_EXT),\
SIMPLE.$(OBJ_EXT),\
SIMPLEMENU.$(OBJ_EXT),\
SME.$(OBJ_EXT)

OBJS5 =\
SMEBSB.$(OBJ_EXT),\
SMELINE.$(OBJ_EXT),\
SMETHREED.$(OBJ_EXT),\
STRIPCHART.$(OBJ_EXT),\
TEXT.$(OBJ_EXT)

OBJS6 =\
TEXTACTION.$(OBJ_EXT),\
TEXTPOP.$(OBJ_EXT),\
TEXTSINK.$(OBJ_EXT),\
TEXTSRC.$(OBJ_EXT),\
TEXTTR.$(OBJ_EXT)

OBJS7 =\
THREED.$(OBJ_EXT),\
TOGGLE.$(OBJ_EXT),\
TREE.$(OBJ_EXT),\
VIEWPORT.$(OBJ_EXT),\
XAWINIT.$(OBJ_EXT)

OBJS8 =\
LAYOUT.$(OBJ_EXT),\
FORM3D.$(OBJ_EXT)

! The following widgets have been excluded
! You may include them but you should edit ALLWIDGETS.C then.

! CLOCK.$(OBJ_EXT),\
! LOGO.$(OBJ_EXT),\
! MAILBOX.$(OBJ_EXT),\

!### Targets ##################################################################

DEFAULT   :   $(TARGET).$(EXE_EXT)
   @  write_ sys$output ""
   @  write_ sys$output "  $(TARGET).$(EXE_EXT), $(TARGET1).$(OPT_EXT) available"
   @  write_ sys$output ""

OPTION_FILES = \
  _OBJS.$(OPT_EXT)/OPT,\
  _LINK.$(OPT_EXT)/OPT

$(TARGET).$(EXE_EXT) :  $(OBJS1), $(OBJS2), $(OBJS3), $(OBJS4), $(OBJS5),\
			$(OBJS6), $(OBJS7), $(OBJS8)
  @ WRITE_ SYS$OUTPUT "  generating _OBJS.$(OPT_EXT)"  
  @ OPEN_/WRITE FILE  _OBJS.$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### _OBJS.$(OPT_EXT) generated for $(TARGET) by DESCRIP.MMS"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "$(OBJS1)"
  @ WRITE_ FILE "$(OBJS2)"
  @ WRITE_ FILE "$(OBJS3)"
  @ WRITE_ FILE "$(OBJS4)"
  @ WRITE_ FILE "$(OBJS5)"
  @ WRITE_ FILE "$(OBJS6)"
  @ WRITE_ FILE "$(OBJS7)"
  @ WRITE_ FILE "$(OBJS8)"
  @ CLOSE_ FILE
  @ OPEN_/APPEND FILE  _OBJS.$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### Shareable Images:"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "$(RTL_LIBRARY)"
  @ WRITE_ FILE "DECW$XEXTLIBSHR/SHARE"
  @ WRITE_ FILE "DECW$XLIBSHR/SHARE"
  @ $(IF_R4) WRITE_ FILE "DECW$XTSHR/SHARE"
  @ $(IF_R5) WRITE_ FILE "DECW$XTLIBSHRR5/SHARE"
  @ WRITE_ FILE "XMULIBSHR/SHARE"   
  @ CLOSE_ FILE       
  @ WRITE_ SYS$OUTPUT "  generating $(TARGET).$(MAP_EXT) ..."
  @ LINK_/NODEB/NOSHARE/NOEXE/MAP=$(TARGET).$(MAP_EXT)/FULL _OBJS.$(OPT_EXT)/OPT
  @ WRITE_ SYS$OUTPUT "  analyzing Map ..."
  @ @X11_LIBRARY:ANALYZE_MAP $(TARGET).$(MAP_EXT) XAW_DIRECTORY:_LINK.$(OPT_EXT)
  @ WRITE_ SYS$OUTPUT "  generating $(TARGET1).$(OPT_EXT)"
  @ OPEN_/WRITE FILE $(TARGET1).$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### $(TARGET1).$(OPT_EXT) generated by DESCRIP.MMS"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### Shareable Images:"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "$(RTL_LIBRARY)"
  @ WRITE_ FILE "DECW$XEXTLIBSHR/SHARE"
  @ WRITE_ FILE "DECW$XLIBSHR/SHARE"
  @ $(IF_R4) WRITE_ FILE "DECW$XTSHR/SHARE"
  @ $(IF_R5) WRITE_ FILE "DECW$XTLIBSHRR5/SHARE"
  @ WRITE_ FILE "XMULIBSHR/SHARE"   
  @ WRITE_ FILE "$(TARGET)/SHARE"   
  @ CLOSE_ FILE
  @ WRITE_ SYS$OUTPUT "  linking $(TARGET).$(EXE_EXT)"
  @ LINK_/NODEB/SHARE=$(TARGET).$(EXE_EXT)/MAP=$(TARGET).$(MAP_EXT)/FULL $(OPTION_FILES)


# dependencies!!! - Richard Levitte /* thanks ###jp### 06/18/95 */

ALLWIDGETS.$(OBJ_EXT)	: XMU_DIRECTORY:WIDGETNODE.H
ASCIISINK.$(OBJ_EXT)	: XAWINIT.H ASCIISINKP.H ASCIISRCP.H TEXTP.H
ASCIISRC.$(OBJ_EXT)	: XAWINIT.H ASCIISRCP.H ASCIITEXT.H CARDINALS.H \
			XMU_DIRECTORY:MISC.H XMU_DIRECTORY:CHARSET.H
ASCIITEXT.$(OBJ_EXT)	: XAWINIT.H CARDINALS.H ASCIITEXTP.H ASCIISRC.H \
			ASCIISINK.H
BOX.$(OBJ_EXT)		: XMU_DIRECTORY:MISC.H XAWINIT.H BOXP.H
CLOCK.$(OBJ_EXT)	: XAWINIT.H CLOCKP.H
COMMAND.$(OBJ_EXT)	: XMU_DIRECTORY:MISC.H XAWINIT.H COMMANDP.H \
			XMU_DIRECTORY:CONVERTERS.H
DIALOG.$(OBJ_EXT)	: XMU_DIRECTORY:MISC.H XAWINIT.H ASCIITEXT.H \
			COMMAND.H LABEL.H DIALOGP.H CARDINALS.H
FORM.$(OBJ_EXT)		: XMU_DIRECTORY:VMS_COMPAT.H \
			XMU_DIRECTORY:VMS_R4_COMPAT.H \
			XMU_DIRECTORY:CONVERTERS.H \
			XMU_DIRECTORY:CHARSET.H XAWINIT.H FORMP.H
GRIP.$(OBJ_EXT)		: XAWINIT.H GRIPP.H
LABEL.$(OBJ_EXT)	: XAWINIT.H LABELP.H XMU_DIRECTORY:CONVERTERS.H \
			XMU_DIRECTORY:DRAWING.H XMU_DIRECTORY:VMS_COMPAT.H \
			XMU_DIRECTORY:VMS_R4_COMPAT.H 
LIST.$(OBJ_EXT)		: XMU_DIRECTORY:DRAWING.H XAWINIT.H LISTP.H
MENUBUTTON.$(OBJ_EXT)	: XAWINIT.H MENUBUTTOP.H
PANED.$(OBJ_EXT)	: XMU_DIRECTORY:MISC.H XMU_DIRECTORY:CONVERTERS.H \
			XAWINIT.H GRIP.H PANEDP.H
PANNER.$(OBJ_EXT)	: XMU_DIRECTORY:CHARSET.H XAWINIT.H PANNERP.H \
			XMU_DIRECTORY:MISC.H XMU_DIRECTORY:DRAWING.H
PORTHOLE.$(OBJ_EXT)	: XAWINIT.H PORTHOLEP.H XMU_DIRECTORY:MISC.H
REPEATER.$(OBJ_EXT)	: XAWINIT.H REPEATERP.H
SCROLLBAR.$(OBJ_EXT)	: XAWINIT.H SCROLLBARP.H XMU_DIRECTORY:DRAWING.H
SIMPLE.$(OBJ_EXT)	: XAWINIT.H SIMPLEP.H XMU_DIRECTORY:DRAWING.H
SIMPLEMENU.$(OBJ_EXT)	: XAWINIT.H SIMPLEMENP.H SMEBSB.H CARDINALS.H \
			XMU_DIRECTORY:INITER.H XMU_DIRECTORY:CHARSET.H
SME.$(OBJ_EXT)		: XAWINIT.H SMEP.H CARDINALS.H
SMEBSB.$(OBJ_EXT)	: XMU_DIRECTORY:DRAWING.H XAWINIT.H SIMPLEMENU.H \
			SMEBSBP.H CARDINALS.H
SMELINE.$(OBJ_EXT)	: XAWINIT.H SMELINEP.H CARDINALS.H
SMETHREED.$(OBJ_EXT)	: XAWINIT.H SMETHREEDP.H
STRIPCHART.$(OBJ_EXT)	: XAWINIT.H STRIPCHARP.H
TEXT.$(OBJ_EXT)		: XMU_DIRECTORY:VMS_COMPAT.H \
			XMU_DIRECTORY:VMS_R4_COMPAT.H  XMU_DIRECTORY:ATOMS.H \
			XMU_DIRECTORY:CHARSET.H XMU_DIRECTORY:CONVERTERS.H \
			XMU_DIRECTORY:STDSEL.H XMU_DIRECTORY:MISC.H XAWINIT.H \
			CARDINALS.H SCROLLBAR.H TEXTP.H
TEXTACTION.$(OBJ_EXT)	: XMU_DIRECTORY:MISC.H TEXTP.H
TEXTPOP.$(OBJ_EXT)	: TEXTP.H ASCIITEXT.H CARDINALS.H COMMAND.H FORM.H \
			TOGGLE.H XMU_DIRECTORY:CHARSET.H
TEXTSINK.$(OBJ_EXT)	: XAWINIT.H TEXTSINKP.H TEXTP.H
TEXTSRC.$(OBJ_EXT)	: XMU_DIRECTORY:VMS_COMPAT.H \
			XMU_DIRECTORY:VMS_R4_COMPAT.H  XAWINIT.H TEXTSRCP.H \
			XMU_DIRECTORY:CHARSET.H
# TEXTTR.$(OBJ_EXT)	: XAWINIT.H
THREED.$(OBJ_EXT)	: XAWINIT.H THREEDP.H
TOGGLE.$(OBJ_EXT)	: XAWINIT.H XMU_DIRECTORY:CONVERTERS.H \
			XMU_DIRECTORY:MISC.H TOGGLEP.H
TREE.$(OBJ_EXT)		: XAWINIT.H CARDINALS.H TREEP.H
VIEWPORT.$(OBJ_EXT)	: XAWINIT.H XMU_DIRECTORY:MISC.H SCROLLBAR.H VIEWPORT.H
XAWINIT.$(OBJ_EXT)	: XAWINIT.H XMU_DIRECTORY:CONVERTERS.H
LAYOUT.$(OBJ_EXT)	: XMU_DIRECTORY:CONVERTERS.H LAYOUTP.H
FORM3D.$(OBJ_EXT)	: XMU_DIRECTORY:VMS_COMPAT.H \
			XMU_DIRECTORY:VMS_R4_COMPAT.H \
			XMU_DIRECTORY:CONVERTERS.H \
			XMU_DIRECTORY:CHARSET.H FORM3DP.H
                        
