#ifdef VMS
#ifdef __DECC
#define mkdir decc$mkdir
#define isatty decc$isatty
#define close decc$close
#define open decc$open
#define creat decc$creat
#define delete decc$delete
#endif
#include <stdlib.h>
#include <string.h>
#include <unixio.h>
#include <unixlib.h>
#endif
#ifdef TEST
#include "INTERN.h"
#else
#include "EXTERN.h"
#endif
#include "common.h"
#include "INTERN.h"
#include "util.h"
#include "backupfile.h"

#ifdef VMS
#include <errno.h>
#include "vl_stdio.h"
#else /* Because VAX C barfs otherwise...  */
#define stat_s struct stat
#endif

void my_exit();

#ifndef HAVE_STRERROR
static char *
private_strerror (errnum)
     int errnum;
{
  extern char *sys_errlist[];
  extern int sys_nerr;

  if (errnum > 0 && errnum <= sys_nerr)
    return sys_errlist[errnum];
  return "Unknown system error";
}
#define strerror private_strerror
#endif /* !HAVE_STRERROR */

/* Rename a file, copying it if necessary. */

int
move_file(from,to)
char *from, *to;
{
    char bakname[512];
    Reg1 char *s;
    Reg2 int i;
    Reg3 int fromfd;

    /* to stdout? */

    if (strEQ(to, "-")) {
#ifdef DEBUGGING
	if (debug & 4)
	    say2("Moving %s to stdout.\n", from);
#endif
#ifdef VMS
	fromfd = open(from, 0, 0, "mbc=64", "mbf=2");
#else
      	fromfd = open(from, 0);
#endif
	if (fromfd < 0)
	    pfatal2("internal error, can't reopen %s", from);
	while ((i=read(fromfd, buf, sizeof buf)) > 0)
	    if (write(1, buf, i) != 1)
		pfatal1("write failed");
	Close(fromfd);
	return 0;
    }

#ifdef VMS
    /* This is not robust -- we just rename the file, hoping for the best. */
    /* This is not efficient, but for simplicity sake, we simply copy	*/
    /* the file, and remove the source.					*/
    copy_file(from, to);
    delete(from);
    return 0;
#else
    if (origprae) {
	Strcpy(bakname, origprae);
	Strcat(bakname, to);
    } else {
#ifndef NODIR
	char *backupname = find_backup_file_name(to);
	if (backupname == (char *) 0)
	    fatal1("out of memory\n");
	Strcpy(bakname, backupname);
	free(backupname);
#else /* NODIR */
	Strcpy(bakname, to);
    	Strcat(bakname, simple_backup_suffix);
#endif /* NODIR */
    }

    if (stat(to, &filestat) == 0) {	/* output file exists */
	dev_t to_device = filestat.st_dev;
	ino_t to_inode  = filestat.st_ino;
	char *simplename = bakname;
	
	for (s=bakname; *s; s++) {
	    if (*s == '/')
		simplename = s+1;
	}
	/* Find a backup name that is not the same file.
	   Change the first lowercase char into uppercase;
	   if that isn't sufficient, chop off the first char and try again.  */
	while (stat(bakname, &filestat) == 0 &&
		to_device == filestat.st_dev && to_inode == filestat.st_ino) {
	    /* Skip initial non-lowercase chars.  */
	    for (s=simplename; *s && !islower(*s); s++) ;
	    if (*s)
		*s = toupper(*s);
	    else
		Strcpy(simplename, simplename+1);
	}
	while (unlink(bakname) >= 0) ;	/* while() is for benefit of Eunice */
#ifdef DEBUGGING
	if (debug & 4)
	    say3("Moving %s to %s.\n", to, bakname);
#endif
	if (rename(to, bakname) < 0) {
	    say4("Can't backup %s, output is in %s: %s\n", to, from,
		 strerror(errno));
	    return -1;
	}
	while (unlink(to) >= 0) ;
    }
#ifdef DEBUGGING
    if (debug & 4)
	say3("Moving %s to %s.\n", from, to);
#endif
    if (rename(from, to) < 0) {		/* different file system? */
	Reg4 int tofd;
	
	tofd = creat(to, 0666);
	if (tofd < 0) {
	    say4("Can't create %s, output is in %s: %s\n",
	      to, from, strerror(errno));
	    return -1;
	}
#ifdef VMS
	fromfd = open(from, 0, 0, "mbc=64", "mbf=2");
#else
      	fromfd = open(from, 0);
#endif
	if (fromfd < 0)
	    pfatal2("internal error, can't reopen %s", from);
	while ((i=read(fromfd, buf, sizeof buf)) > 0)
	    if (write(tofd, buf, i) != i)
		pfatal1("write failed");
	Close(fromfd);
	Close(tofd);
    }
    Unlink(from);
#endif	/* VMS */
    return 0;
}

/* Copy a file. */

void
copy_file(from,to)
char *from, *to;
{
    Reg3 int tofd;
    Reg2 int fromfd;
    Reg1 int i;
    
    tofd = creat(to, 0666
#ifdef VMS
		 , "rfm=stmlf", "mbc=64", "mbf=2"
#endif
		 );
    if (tofd < 0)
	pfatal2("can't create %s", to);
    fromfd = open(from, 0
#ifdef VMS
		  , 0, "mbc=64", "mbf=2"
#endif
		  );
    if (fromfd < 0)
	pfatal2("internal error, can't reopen %s", from);
    while ((i=read(fromfd, buf, sizeof buf)) > 0)
	if (write(tofd, buf, i) != i)
	    pfatal2("write to %s failed", to);
    Close(fromfd);
    Close(tofd);
}

/* Allocate a unique area.  */

void *
mymalloc (l)
Reg1 unsigned int l;
{
    Reg2 char *rv;

    rv = malloc((MEM) l);
    if (rv == Nullch) {
	if (using_plan_a)
	    out_of_mem = TRUE;
	else
	    fatal1("out of memory\n");
    }
    return rv;
}
/* Allocate a unique area for a string. */

char *
savestr(s)
Reg1 char *s;
{
    Reg3 char *rv;
    Reg2 char *t;

    if (!s)
	s = "Oops";
    t = s;
    while (*t++);

    rv = mymalloc((MEM) (t - s));

    t = rv;
    while (*t++ = *s++);

    return rv;
}

#if defined(lint) && defined(CANVARARG)

/*VARARGS ARGSUSED*/
say(pat) char *pat; { ; }
/*VARARGS ARGSUSED*/
fatal(pat) char *pat; { ; }
/*VARARGS ARGSUSED*/
pfatal(pat) char *pat; { ; }
/*VARARGS ARGSUSED*/
ask(pat) char *pat; { ; }

#else

/* Vanilla terminal output (buffered). */

void
say(pat,arg1,arg2,arg3)
char *pat;
long arg1,arg2,arg3;
{
    fprintf(stderr, pat, arg1, arg2, arg3);
    Fflush(stderr);
}

/* Terminal output, pun intended. */

void				/* very void */
fatal(pat,arg1,arg2,arg3)
char *pat;
long arg1,arg2,arg3;
{
    fprintf(stderr, "patch: **** ");
    fprintf(stderr, pat, arg1, arg2, arg3);
    my_exit(1);
}

/* Say something from patch, something from the system, then silence . . . */

void				/* very void */
pfatal(pat,arg1,arg2,arg3)
char *pat;
long arg1,arg2,arg3;
{
    int errnum = errno;

    fprintf(stderr, "patch: **** ");
    fprintf(stderr, pat, arg1, arg2, arg3);
    fprintf(stderr, ": %s\n", strerror(errnum));
    my_exit(1);
}

/* Get a response from the user, somehow or other. */

void
ask(pat,arg1,arg2,arg3)
char *pat;
long arg1,arg2,arg3;
{
    int ttyfd;
    int r;
    bool tty2 = isatty(2);
#ifdef VMS
    static char *ttyname = "TT:";
#else
    static char *ttyname = "/dev/tty";
#endif

    Sprintf(buf, pat, arg1, arg2, arg3);
#ifndef VMS
    Fflush(stderr);
    write(2, buf, strlen(buf));
    if (tty2) {				/* might be redirected to a file */
	r = read(2, buf, sizeof buf);
    }
    else if (isatty(1)) {		/* this may be new file output */
	Fflush(stdout);
	write(1, buf, strlen(buf));
	r = read(1, buf, sizeof buf);
    }
    else
#if 0
      {}
#endif
#endif
    if ((ttyfd = open(ttyname, 2, 0)) >= 0) {
      if (isatty(ttyfd)) {
					/* might be deleted or unwriteable */
	write(ttyfd, buf, strlen(buf));
	r = read(ttyfd, buf, sizeof buf);
      }
      Close(ttyfd);
    }
    else if (isatty(0)) {		/* this is probably patch input */
	Fflush(stdin);
	write(0, buf, strlen(buf));
	r = read(0, buf, sizeof buf);
    }
    else {				/* no terminal at all--default it */
	buf[0] = '\n';
	r = 1;
    }
    if (r <= 0)
	buf[0] = 0;
    else
	buf[r] = '\0';
    if (!tty2)
	say1(buf);
}
#endif /* lint */

/* How to handle certain events when not in a critical region. */

void
set_signals(reset)
int reset;
{
#ifndef lint
    static RETSIGTYPE (*hupval)(),(*intval)();

    if (!reset) {
	hupval = signal(SIGHUP, SIG_IGN);
	if (hupval != SIG_IGN)
	    hupval = (RETSIGTYPE(*)())my_exit;
	intval = signal(SIGINT, SIG_IGN);
	if (intval != SIG_IGN)
	    intval = (RETSIGTYPE(*)())my_exit;
    }
    Signal(SIGHUP, hupval);
    Signal(SIGINT, intval);
#endif
}

/* How to handle certain events when in a critical region. */

void
ignore_signals()
{
#ifndef lint
    Signal(SIGHUP, SIG_IGN);
    Signal(SIGINT, SIG_IGN);
#endif
}

/* Make sure we'll have the directories to create a file.
   If `striplast' is TRUE, ignore the last element of `filename'.  */

void
makedirs(filename,striplast)
Reg1 char *filename;
bool striplast;
{
#ifdef VMS
    Reg2 char *s = fetchname(filename, 0, 1);
    Reg3 char *t = strchr(s, ']');
    if (t == 0)
      t = strchr(s, '>');
    if (t != 0)
      {
	*++t = '\0';
	if (mkdir(s, 0) < 0 && errno != EEXIST)
	  pfatal ("can't create directory %s", s);
      }
#else
    char tmpbuf[256];
    Reg2 char *s = tmpbuf;
    char *dirv[20];		/* Point to the NULs between elements.  */
    Reg3 int i;
    Reg4 int dirvp = 0;		/* Number of finished entries in dirv. */

    /* Copy `filename' into `tmpbuf' with a NUL instead of a slash
       between the directories.  */
    while (*filename) {
	if (*filename == '/') {
	    filename++;
	    dirv[dirvp++] = s;
	    *s++ = '\0';
	}
	else {
	    *s++ = *filename++;
	}
    }
    *s = '\0';
    dirv[dirvp] = s;
    if (striplast)
	dirvp--;
    if (dirvp < 0)
	return;

    strcpy(buf, "mkdir");
    s = buf;
    for (i=0; i<=dirvp; i++) {
	stat_s sbuf;

	if (stat(tmpbuf, &sbuf) && errno == ENOENT) {
	    while (*s) s++;
	    *s++ = ' ';
	    strcpy(s, tmpbuf);
	}
	*dirv[i] = '/';
    }
    if (s != buf)
	system(buf);
#endif /* VMS */
}

/* Make filenames more reasonable. */

char *
fetchname(at,strip_leading,assume_exists)
char *at;
int strip_leading;
int assume_exists;
{
    char *fullname;
    char *name;
    Reg1 char *t;
    char tmpbuf[200];
    int sleading = strip_leading;

    if (!at)
	return Nullch;
    while (isspace(*at))
	at++;
#ifdef DEBUGGING
    if (debug & 128)
	say4("fetchname %s %d %d\n",at,strip_leading,assume_exists);
#endif
    if (strnEQ(at, "/dev/null", 9))	/* so files can be created by diffing */
	return Nullch;			/*   against /dev/null. */
#ifdef VMS
    if (strnEQ(at, "NLA0:", 5) || strnEQ(at, "NL:", 3))
      return Nullch;
#endif
    name = fullname = t = savestr(at);

#ifdef VMS
    {
      char *s2 = (char *) mymalloc (strlen(name) + 20);
      char *t2 = s2;
      char *component_start = 0, *component_end = 0;
      int device_done = 0, first_dir_done = 0, rooted = 0;

      for(t = name, component_start = name; *t != '\0'; t++)
	{
	  switch(*t)
	    {
	    case '/':
	      *t = '\0';
	      if (t != name)
		{
		  if (strcmp(component_start, ".") == 0)
		    ;
		  else if (strcmp(component_start, "..") == 0)
		    {
		      if (!first_dir_done)
			{
			  first_dir_done = 1;
			  *t2++ = '[';
			}
		      else
			*t2++ = '.';
		      *t2++ = '-';
		    }
		  else if (first_dir_done)
		    {
		      *t2++ = '.';
		      strcpy(t2, component_start);
		      t2 += strlen(t2);
		    }
		  else if (rooted && !device_done)
		    {
		      strcpy(t2, component_start);
		      t2 += strlen(t2);
		      *t2++ = ':';
		    }
		  else
		    {
		      /* Now, there's just the case of the first dir */
		      *t2++ = '[';
		      if (!rooted)
			*t2++ = '.';
		      strcpy(t2, component_start);
		      t2 += strlen(t2);

		      first_dir_done = 1;
		    }
		  device_done = 1;
		}
	      else
		{
		  rooted = 1;
		}
	      component_start = t + 1;
	      break;
	    }
	}
      if (t2 != fullname && rooted && !first_dir_done)
	{
	  strcpy(t2, "[000000");
	  t2 += 7;
	  first_dir_done = 1;
	}
      if (first_dir_done)
	*t2++ = ']';
      if (component_start != t)
	{
	  int count_dots=0;
	  strcpy(t2, component_start);
	  component_start = strchr(t2, ']');
	  if (component_start)
	    t2 = component_start + 1;
	  for(; *t2 != '\0'; t2++)
	    switch (*t2)
	      {
	      case '.':
		if (count_dots)
		  *t2 = '_';	/* We have no use of version numbers */
		count_dots = 1;
		break;
	      case '+':
		*t2 = '_';
		break;
	      case '#':
		*t2 = '$';
		break;
	      }
	}
      else
	{
	  free(s2);
	  free(name);
	  name = Nullch;
	  return name;
	}
      free(fullname);
      fullname = s2;
      name = t = fullname;
    }
#endif

#ifdef VMS
    for (t = name; *t && !isspace(*t); t++);
    *t = '\0';

    if (strip_leading != 957)
      {
	int inside = 0;
	int addbracket = 0, addangle = 0, adddot = 0;
	for (t = name; *t; t++)
	  {
	    if (*t == '[' || *t == '<')
	      {
		inside = 1;
		if (*(t+1) != '.')
		  if (--sleading >= 0)
		    name = t+1,
		    addbracket = (*t == '['), addangle = (*t == '<'),
		    adddot = 1;
		  else
		    t++,
		    addbracket = (*t == '['), addangle = (*t == '<'),
		    adddot = 1;
	      }
	    else if (*t == ':')
	      {
		if (--sleading >= 0)
		  name = t+1;
		inside = 1;
	      }
	    else if (*t == '.' && inside)
	      {
		if (--sleading >= 0)
		  name = t+1;
		adddot = 1;
	      }
	    else if (*t == ']' || *t == '>')
	      {
		if (--sleading >= 0)
		  name = t+1;
		inside = 0;
	      }
	  }
	*t = '\0';

	if (name != fullname)
	  {
	    char *s = t = (char *) mymalloc (strlen (name)
					     + 1 + adddot + (addbracket
							     | addangle));
	    if (addbracket) *t++ = '[';
	    else if (addangle) *t++ = '<';
	    if (adddot) *t++ = '.';
	    while (*t++ = *name++);
	    name = s;
	    free (fullname);
	  }
      }
#else
    /* Strip off up to `sleading' leading slashes and null terminate.  */
    for (; *t && !isspace(*t); t++)
	if (*t == '/')
	    if (--sleading >= 0)
		name = t+1;
    *t = '\0';

    /* If no -p option was given (957 is the default value!),
       we were given a relative pathname,
       and the leading directories that we just stripped off all exist,
       put them back on.  */
    if (strip_leading == 957 && name != fullname && *fullname != '/') {
	name[-1] = '\0';
	if (stat(fullname, &filestat) == 0 && S_ISDIR (filestat.st_mode)) {
	    name[-1] = '/';
	    name=fullname;
	}
    }

    name = savestr(name);
    free(fullname);
#endif

#ifdef DEBUGGING
    fprintf (stderr, "name = %s\n", name);
#endif

    if (stat(name, &filestat) && !assume_exists) {
#ifdef VMS
#ifdef DEBUGGING
      if (debug & 1)
	{
	  char *s = getcwd(0,1000);
	  printf("File not accessible: %s %s\n", s, name);
	  free(s);
	}
#endif
	free(name);
	name = Nullch;
    }
#if 0
    else
    {
#endif
#else
        char *filebase = basename(name);
	int pathlen = filebase - name;

	/* Put any leading path into `tmpbuf'.  */
	strncpy(tmpbuf, name, pathlen);

#define try(f, a1, a2) (Sprintf(tmpbuf + pathlen, f, a1, a2), stat(tmpbuf, &filestat) == 0)
	if (   try("RCS/%s%s", filebase, RCSSUFFIX)
	    || try("RCS/%s"  , filebase,         0)
	    || try(    "%s%s", filebase, RCSSUFFIX)
	    || try("SCCS/%s%s", SCCSPREFIX, filebase)
	    || try(     "%s%s", SCCSPREFIX, filebase))
	  return name;
	free(name);
	name = Nullch;
    }
#endif	/* VMS */

    return name;
}

char *
xmalloc (size)
     unsigned size;
{
  register char *p = (char *) malloc (size);
  if (!p)
    fatal("out of memory");
  return p;
}

#ifdef TEST
main()
{
  char *files[] = {
    "/foo/bar/cookie.h.in",
    "foo/bar/cookie.h",
    "/./foo/bar",
    "/../foo/bar",
    "/./foo",
    "/../foo",
    "./foo/bar",
    "../foo/bar",
    "./foo",
    "../foo",
    "/foo/./bar/cookie.h.in",
    "/foo/../bar/cookie.h.in",
    "/foo/./cookie.h.in",
    "/foo/../cookie.h.in",
    "foo/./bar/cookie.h.in",
    "foo/../bar/cookie.h.in",
    "foo/./cookie.h.in",
    "foo/../cookie.h.in",
    "cookie.h.in",
    0 };
     
  char **s = files;

  for(; *s != 0; s++)
    {
      char *name = fetchname(*s, 0, 1);
      printf("%s -> %s\n", *s, name);
      free(name);
    }
}

void my_exit(int i)
{
  exit(i);
}
#endif
